function Component()
{
    installer.installationFinished.connect(this, installationFinishedPageIsShown);
    installer.finishButtonClicked.connect(this, installationFinished);
}

Component.prototype.isDefault = function()
{
    return true;
}

function createShortcuts()
{
    if(systemInfo.kernelType == "winnt")
    {
        component.addOperation("CreateShortcut", "@TargetDir@/Ether.exe", "@StartMenuDir@/Ether.lnk");
        component.addOperation("CreateShortcut", "@TargetDir@/Ether.exe", "@DesktopDir@/Ether.lnk");
    }
}

Component.prototype.createOperations = function()
{
    component.createOperations();
    createShortcuts();
}

installationFinishedPageIsShown = function()
{
    try
    {
        if (installer.isInstaller() && installer.status == QInstaller.Success && systemInfo.kernelType == "winnt")
        {
            installer.addWizardPageItem( component, "StartupCheckBoxForm", QInstaller.InstallationFinished );
        }
    }
    catch(e)
    {
        console.log(e);
    }
}

installationFinished = function()
{
    try
    {
        if (installer.isInstaller() && installer.status == QInstaller.Success && systemInfo.kernelType == "winnt")
        {
            var isStartupCheckBoxChecked = component.userInterface( "StartupCheckBoxForm" ).startupCheckBox.checked;
            if (isStartupCheckBoxChecked)
            {
                var linkPath = installer.value("UserStartMenuProgramsPath") + "/Startup/Ether.lnk";
                var executablePath = installer.value("TargetDir") + "/Ether.app/Contents/MacOS/Ether";
                installer.performOperation("CreateShortcut", [executablePath, linkPath]);
            }
        }
    }
    catch(e)
    {
        console.log(e);
    }
}
